#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# @(#)32   1.36   src/csm/core/pm/ServerUtils.pm.perl, setup, csm_rameh, rameh_base 6/28/04 16:03:40
#
#####################################################################

package ServerUtils;

use strict;

#            locale tells perl to honor locale for sorting, dates, etc.
#            More info about locale.pm and perl handling of locales can be found in
#            /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.
use locale;
use Socket;

use Fcntl qw(:flock);
use File::Basename;
use File::Find;
use File::Path;    # Provides mkpath()

my $msgs;
my $distro;
my $useTranslatedMsg;
my %catHashes;
my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);
my $NO_NODERANGES;
my $NODEGROUPEXPMEM_WARNING = 1;

# $NodeUtils::NO_MESSAGES;    # Set this to 1 if you do not want NodeUtils to
# print any error msgs

# $NodeUtils::errno;          # Will be set if an error occurs.  You must zero
# this out before calling a NodeUtils function,
# if you want to check it afterwards.

BEGIN
{

    #    This enables us to redirect where it looks for other CSM files during development
    $csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';

    $MSGCAT = 'nodecmds.cat';
    if (defined $::MSGMAPPATH)
    {
        $MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
    }
    else
    {
        $MSGMAPPATH = "$csmroot/msgmaps";
    }
    $MSGSET = 'NodeUtils';
}

umask(0022);   #  This sets umask for all CSM files so that group and world only
               #  have read permissions.
               #  To change it, simply use the umask call in your script, after
               #  the "use ServerUtils;" line

#--------------------------------------------------------------------------------

=head1    ServerUtils

=head2    Package Description

This program module file, supports the CSM/install server-side dependencies.

If adding to this file, please take a moment to ensure that:

    1.  Your contrib has a readable pod header describing the purpose and use of
         your contrib.

    2. Your contrib is under the correct heading and is in alphabetical order
    under that heading.

    3. You test your contribution by running from the command line:  

       pod2html  --verbose --title=ServerUtils ServerUtils.pm.perl --outfile=ServerUtils.html
       
       and examining the ./ServerUtils.html file in a browser.


=cut

#--------------------------------------------------------------------------------

=head2    Package Dependancies

    use strict;
    use Fcntl qw(:flock);
    use File::Basename;
    use File::Find;
    use File::Path;    # Provides mkpath()

=cut

#--------------------------------------------------------------------------------

=head2    Misc Tools

=cut

#--------------------------------------------------------------------------------

=head3    close_delete_file

        Closes and deletes the file specified by the two input parameters.

        Arguments:
                $file handle
                $file name
        Returns:
                null
        Error:
                none
        Example:
                ServerUtils->close_delete_file($::NODE_LIST_FILE, $nodelist_file);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub close_delete_file
{
    my ($class, $file_handle, $file_name) = @_;
    close $file_handle;

    my $cmd = "$::RM -f $file_name";
    my $rc  = system($cmd) >> 8;
    if ($rc)
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E', 'EMsgCANT_RUN', $cmd, $rc);
    }
}

#--------------------------------------------------------------------------------

=head3    copy_exceptions_rveg

        A subroutine to hold some file copy hacks for the vega release.

	The rotuine has the release name rveg attached to it, to motiveate those who
	come later to fix the underlying problem for the next release.

        Arguments:
		n/a
        Returns:
                null
        Error:
                none
        Example:
                n/a
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub copy_exceptions_rveg
{
    my (
        $distro_name,    # eg RedHat or SLES (case sensitive)
        $filename        # the name of the file to test.
    ) = @_;

    my $server = $::PLTFRM; # the managment server doing the install

    # This hack relates to an interoprability issue between AIX and Linux.
    # When AIX runs copycsmpkgs on a Linux Distro, it tries to copy a few too many files...

    if (   ($server eq "AIX") &&
        (  ($distro_name =~ /RedHat/)
        || ($distro_name =~ /SLES/)
        || ($distro_name =~ /SuSE/) )
        )
    {

        # just test against the filenames one at a time
        if ($filename eq "/opt/csm/csmbin/nodestatus.client")	{ return $::NOK; }
        if ($filename eq "/opt/csm/csmbin/setbootdisk")		{ return $::NOK; }
        if ($filename eq "/usr/lib/syslinux/pxelinux.0")	{ return $::NOK; }
    }

    return $::OK;
}

#--------------------------------------------------------------------------------

=head3    get_lock

        get ownership of a non-blocking semiphore / file

        Arguments:
                $fileName
        Returns:
                2  if it couldn't open $fileName
                3  if it couldn't lock $fileName
        Error:
                messageFromCat E1
        Example:
                ServerUtils->get_lock("/tmp/updateisvr.sem");_
        Comments:
                get_lock() and release_lock() implement semiphore locking for csm comnands
                such as updatenode.perl.  The devleoper obtains a lock at the beginning
                of execution and hold it until the script completes. It is
                guaranteed that two or more instances of the script will NOT be able to 
                run concurrently.

                This is not a blocking lock.  If a script calls get_lock while another
                instance of the same script has not released the lock, the calling script
                will fail. If the script exits for any reason, the lock is released.

=cut

#--------------------------------------------------------------------------------

sub get_lock
{
    my ($class, $file) = @_;
    my $return_code = 0;
    my $program     = NodeUtils->programName();
    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                              "V", 'IMsgGet_Lock', $file, $program);
    if (!open(SEM, ">$file"))
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',      $::MSGMAPPATH,
                                  'csminstall',          "E1",
                                  'EMsgSEMAPHORE_ERROR', $file,
                                  "$? $!"
                                  );
    }
    if (!flock(SEM, LOCK_EX | LOCK_NB))
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat', $::MSGMAPPATH,
                                  'csminstall',     "E1",
                                  'EMsgLOCK_ERROR', $program,
                                  $file,            "$? $!"
                                  );
    }
}

#--------------------------------------------------------------------------------

=head3    get_uniqu_arry_elemnts

         Returns the unique elements in an array

        Arguments:
                @array_to_examined
        Returns:
                @array_of_unique_ele
        Globals:
                none
        Error:
                undefined
        Example:
                 @::os_prereq =
                        ServerUtils->get_uniqu_arry_elemnts( @::os_prereq );
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_uniqu_arry_elemnts
{
    my ($class, @my_arry) = @_;
    my %my_hsh = ();
    my @uniq   = ();
    my $itm;
    foreach $itm (@my_arry)
    {
        $my_hsh{$itm}++;
    }
    @uniq = keys %my_hsh;
    return @uniq;
}

#--------------------------------------------------------------------------------

=head3    isAutoupdateInstalled

        Checks to see if the Autoupdate RPM is installed on a Management Server

        Arguments:
        nodeHash
        Returns:
                returns 1 if Autoupdate is installed
            0 otherwise
        Globals:
                none
        Error:
                none
        Example:
         none
        Comments:
                This make sense only on a managment server.

=cut

#--------------------------------------------------------------------------------

sub isAutoupdateInstalled
{
    my ($class, $destnodekey) = @_;
    my $exit = 1;    #assume it is installed
      #Autoupdate should be in /csminstall/Linux/<InstallDistributionName>/csm/<InstallCSMVersion>/packages/
      #EX: /csminstall/Linux/RedHat/csm/1.3.0/packages/autoupdate-4.0.1-1.noarch.rpm

    #determine possible directory structures
    my %directories = ();
    foreach my $node (keys %$destnodekey)
    {
        if ($$destnodekey{$node}{'InstallOSName'} eq "Linux")
        {
            my $distro  = $$destnodekey{$node}{'InstallDistributionName'};
            my $version = $$destnodekey{$node}{'InstallCSMVersion'};
            if ($version >= 1.3)
            {
                my $dir = "/csminstall/Linux/$distro/csm/$version/packages/";
                $directories{$dir} = 1;
            }
        }
    }

    #check if there is an autoupdate rpm in the directory
    foreach my $dir (keys %directories)
    {
        `/bin/ls $dir/autoupdate*.rpm 2>/dev/null`;
        my $rc = $? >> 8;
        if ($rc != 0)
        {    #autoupdate isn't there
            NodeUtils->messageFromCat(
                      'csmInstall.cat',                           $::MSGMAPPATH,
                      'csminstall',                               'E',
                      'EMsgNoAutoupdate',                         $dir,
                      "http://freshmeat.net/projects/autoupdate", $dir
                      );
            $exit = 0;
        }
    }
    return $exit;
}

#--------------------------------------------------------------------------------

=head3 release_lock

        Releases a non-blocking semiphore /  file

        Arguments:
                $fileName
        Returns:
                2  if it couldn't open $fileName
                3  if it couldn't lock $fileName
        Error:
                messageFromCat E1
        Example:
                ServerUtils->get_lock("/tmp/updateisvr.sem");_
        Comments:
                get_lock() and release_lock() implement semiphore locking for csm comnands
                such as updatenode.  The develeoper obtains a lock at the beginning
                of execution and hold it until the script completes. It is
                guaranteed that two or more instances of the script will NOT be able to 
                run concurrently.

                This is not a blocking lock.  If a script calls get_lock while another
                instance of the same script has posession of the lock, the calling script
                will fail. If a script exits for any reason, the lock will be released.

=cut

#--------------------------------------------------------------------------------

sub release_lock
{
    my ($class, $file) = @_;

    close(SEM);
    if (-e "$file")
    {
        system("/bin/rm -f $file");
    }
}

#--------------------------------------------------------------------------------

=head2    Cluster Layer

=cut

#--------------------------------------------------------------------------------

=head3    makeSyncHash

        Returns a hash of which directories to distribute to which Install Servers.
        Assigns a value to the global: %::INSTALL_SERVERS - this is an array of the 
        host names of all the install servers in the cluster.                                              

        Arguments:
                %DestNodeHash (where InstallServer is one of the attributes).
        Returns:
                Hash of directory name arrays by install server keys
        Globals:
                %::INSTALL_SERVERS
        Error:
                undefined
        Example:
                 my $sHash =
                   ServerUtils->makeSyncHash($DestNodeHash);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub makeSyncHash
{
    my ($class, $DestNodeHash) = @_;
    my $defDir = "/csmserver";
    my %sHash;
    my $ms_used = 0;
    %::INSTALL_SERVERS = ();
    my @install_servers = ();
    my $progname        = NodeUtils->programName();

    #hash of directory{replacement name}{installserver}
  NODE: foreach my $node (keys %$DestNodeHash)
    {
        my $InstallOSName           = $$DestNodeHash{$node}{'InstallOSName'};
        my $InstallDistributionName =
          $$DestNodeHash{$node}{'InstallDistributionName'};
        if ($$DestNodeHash{$node}{'InstallServer'})
        {
            if ($$DestNodeHash{$node}{'ManagementServer'} eq
                $$DestNodeHash{$node}{'Hostname'})
            {

                #this machine is a MS and a node
                $ms_used = 1;
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                             'csminstall', 'W', 'EMsgMSNoInstallServer', $node);
                next NODE;
            }
            my ($server, $rep_dir) = split ':',
              $$DestNodeHash{$node}{'InstallServer'};
            if ($server)
            {
                if ($server eq $$DestNodeHash{$node}{'ManagementServer'})
                {
                    $ms_used = 1;

                    #this node's install server is the same as the managment server
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                             'csminstall', 'I', 'IMsgMSisInstallServer', $node);
                    next NODE;
                }
                if ($progname =~ m/installnode/)
                {

                    #make sure a machine is not an install server of itself
                    my ($node_hostname, $node_ip) = NodeUtils->getHost($node);
                    my ($isvr_hostname, $isvr_ip) = NodeUtils->getHost($server);
                    if ($node_hostname eq $isvr_hostname)
                    {
                        $ms_used = 1;
                        NodeUtils->messageFromCat('csmInstall.cat',
                                               $::MSGMAPPATH, 'csminstall', 'W',
                                               'EMsgISVR_OF_ITSELF', $node);
                        next NODE;
                    }
                }
                my $dir = $defDir;
                if ($rep_dir)
                {

                    #todo: check to make sure this start with a /
                    $dir = $rep_dir;
                }

                #transfer /csminstall/csm/* to all nodes
                push @{$sHash{"/csminstall/csm/"}{$dir}}, $server;

                #%{$::INSTALL_SERVERS{$server}} = (); #hash of a hash
                push @install_servers, $$DestNodeHash{$node}{'InstallServer'};

                #find node attributes

                my $InstallDistributionVersion =
                  $$DestNodeHash{$node}{'InstallDistributionVersion'};

				my $InstallPkgArchitecture = $$DestNodeHash{$node}{'InstallPkgArchitecture'};

                if ($InstallOSName eq "Linux")
                {

                    #All Linux nodes: /csminstall/Linux/<InstallDistributionName>/csm/*
                    # /csminstall/Linux/<InstallDistributionName>/<InstallDistributionVersion>/*
                    push @{$sHash{
                            "/csminstall/Linux/$InstallDistributionName/csm/"}
                          {$dir}}, $server;
                    push @{
                        $sHash{
                            "/csminstall/Linux/$InstallDistributionName/$InstallDistributionVersion/$InstallPkgArchitecture/"
                          }{$dir}
                      },
                      $server;
                }
                elsif ($InstallOSName eq "AIX")
                {

                    #All AIX Nodes: /csminstall/AIX/csm/*
                    push @{$sHash{"/csminstall/AIX/csm/"}{$dir}}, $server;
                }
                else
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                 'csminstall', 'E1', 'EMsgUnsupportedOS', $node,
                                 $InstallOSName);
                }

            }
            else
            {

                #management server is a server
                $ms_used = 1;
            }
        }
        else
        {
            $ms_used = 1;
        }
    }
    if (!$ms_used)
    {
        $::MS_INSTALL_SERVER = 0;
    }

    #figure out if any of the install servers are also nodes
    foreach my $entry (@install_servers)
    {
        my ($server, $dir) = split ':', $entry;
        if (!$dir) { $dir = $::SERVER_DIRECTORY; }
        if (exists $$DestNodeHash{$server})
        {    #it is a node
            $::INSTALL_SERVERS{'isnode'}{$server}{'dir'} = $dir;
            $::INSTALL_SERVERS{'isnode'}{$server}{'OS'}  =
              $$DestNodeHash{$server}{'InstallOSName'};
            $::INSTALL_SERVERS{'isnode'}{$server}{'DISTRO'} =
              $$DestNodeHash{$server}{'InstallDistributionName'};
        }
        else
        {    #not a node
            my ($real_hostname, $ip) = NodeUtils->getHost($server);

            #print "REAL HOSTNAME = $real_hostname\n";
            $::INSTALL_SERVERS{'notnode'}{$real_hostname}{'dir'} = $dir;
        }
    }
    if (scalar @install_servers)
    {
        for (@install_servers) { s/:.*// }    #remove directory
        my $unreachable = InstallUtils->checkRSReachability(\@install_servers);
        if ($unreachable != 0)
        {
            if (scalar @$unreachable >= 1)
            {

                #there are unreachable InstallServers
                my $isvrs = join ",", @$unreachable;
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall', 'E1', 'EMsgISDown', $isvrs);
            }
        }
    }

    return (\%sHash);
}

#--------------------------------------------------------------------------------

=head3    syncServers

        Syncronize a cluster's Install Servers. 

        Arguments:
                 Reference to a nodeName Hash;
        Returns:
                0 on error
        Globals:
                %::INSTALL_SERVERS
        Error:
                0 - there are no install servers in the cluster.
        Example:
                 ServerUtils->syncServers(\%DestNodeHash);
        Comments:
                 The caller of this function must use CFM. 

=cut

#--------------------------------------------------------------------------------

sub syncServers
{

    #use CFM -- all commands that call this function need to use CFM

    my ($class, $DestNodeHash) = @_;
    my $sHash = InstallUtils->makeSyncHash($DestNodeHash);
    if (!keys %::INSTALL_SERVERS)
    {    #there are no install servers
        return 0;
    }
    my $distro = NodeUtils->get_DistributionName();

    #rsync is no longer used for SuSE and SLES
    #    if(($distro eq "SuSE") || ($distro eq "SLES")){

    #        CFM->rsyncIsvrs($sHash);
    #PROBLEM: the links are being made wrong:  RPMS -> /csminstall/Linux/SuSE/8.0/i386/SuSE/RPMS or wait,
    #    }
    #    else{ #use rdist
    my $distlocation = "/tmp/csm_servers";
    CFM->createGenDistfile($sHash, $distlocation);
    CFM->distGenDistfile($distlocation);

    #    }
}

#--------------------------------------------------------------------------------

=head2    Filesystem Layer

=cut

#--------------------------------------------------------------------------------

=head3 copyBinaries

        This function takes functionality from installms so that the commands
        updatenode, rmnode, and csmsetupnim can ensure that the latest binaries
        are located in the /csminstall/csm directory.

        This function does the following:
                1. create the /csminstall/csm directory if it doesn't exist 
                2. create the /csminstall/csm/script directories 
                3. copy the binaries into /csminstall/csm, including the defs and pkdefs
                   directory, if the timestamp of the files in /csminstall/csm are older
                   than those installed on the system.
                4. copies updateglibc._RedHat80Nodes for RedHat
                5. copies /tftpboot files for Linux 
                6. Copies hardware control ucode files on AIX to /csminstall/AIX/ucode  
        Arguments:
                none
        Returns:
                none
        Globals:
                $::PREINSTALLDIR
                $::POSTINSTALLDIR
                $::UPDATEDIR
                $::SCRIPTDATADIR"
        Error:
                none
        Example:
                ServerUtils->copyBinaries;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub copyBinaries
{
    my (
        $class,
        $osname,            # eg Linux or AIX (case sensitive)
        $distro_name,       # eg RedHat or SuSE (case sensitive)
        $distro_version,    # eg 7.3 or 5.2
        $hw_arch,           # eg i386, ppc
        $csm_version,       # eg 1.3.0
    ) = @_;

    my $INSTALLDIR_CSM = "/csminstall/csm";

    #
    # Get information about the OS, distribution, and package
    #
    my %pkginfo;
    ($osname) and $pkginfo{'OSName'} = $osname;
    (!$osname)
      and $pkginfo{'OSName'} = InstallUtils->get_OSName;    #AIX/Linux

    ($distro_name) and $pkginfo{'DistributionName'} = $distro_name;
    (!$distro_name)
      and $pkginfo{'DistributionName'} = NodeUtils->get_DistributionName;

    ($distro_version) and $pkginfo{'DistributionVersion'} = $distro_version;
    (!$distro_version)
      and $pkginfo{'DistributionVersion'} = NodeUtils->get_DistributionVersion;

    ($hw_arch) and $pkginfo{'PkgArchitecture'} = $hw_arch;
    (!$hw_arch)
      and $pkginfo{'PkgArchitecture'} = InstallUtils->get_PkgArchitecture;

    if ($pkginfo{'PkgArchitecture'} =~ /i.86/)
    {
        $pkginfo{'PkgArchitecture'} = "i386";
    }

    ($csm_version) and $pkginfo{'CsmCoreVersion'} = $csm_version;
    (!$csm_version)
      and $pkginfo{'CsmCoreVersion'} =
      InstallUtils->get_CSMVersion("csm\.core");

    if (length($pkginfo{'CsmCoreVersion'}) == 0)
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgNO_CORE');
    }

    #
    # Create the /csminstall/csm directory if it doesn't exist
    # NOTE: This function will not create any operating system specific
    #       directories, such as /csminstall/csm/AIX
    if (!-d "$INSTALLDIR_CSM")
    {
        mkpath($INSTALLDIR_CSM, $::VERBOSE, 0755);
    }

    # make the script sub-directories if they don't exist
    if (!-d "$::PREINSTALLDIR")
    {
        mkpath($::PREINSTALLDIR, $::VERBOSE, 0755);
    }
    if (!-d "$::POSTINSTALLDIR")
    {
        mkpath($::POSTINSTALLDIR, $::VERBOSE, 0755);
    }
    if (!-d "$::UPDATEDIR")
    {
        mkpath($::UPDATEDIR, $::VERBOSE, 0755);
    }
    if (!-d "$::SCRIPTDATADIR")
    {
        mkpath($::SCRIPTDATADIR, $::VERBOSE, 0755);
    }

    #
    # Store the pkgdefs into a hash
    #
    my %Svrpkgdefs =
      InstallUtils->get_pkgdefs(
                  $pkginfo{'OSName'},              $pkginfo{'DistributionName'},
                  $pkginfo{'DistributionVersion'}, $pkginfo{'PkgArchitecture'},
                  "MgmtServer",                    $pkginfo{'CsmCoreVersion'}
                  );

    #
    # Get the list of binaries to copy
    #
    my @csm_bin_file_csm      = (@{$Svrpkgdefs{csm_bin_copy_csm}});
    my @csm_bin_file_tftpboot = (@{$Svrpkgdefs{csm_bin_copy_tftpboot}});

    # Files to copy to /csminstall/csm
    foreach my $bin_file (@csm_bin_file_csm)
    {
        my @temper_val  = ();
        my $temper_file = ();
        @temper_val  = split(/\//, $bin_file);
        $temper_file = $temper_val[$#temper_val];
        $temper_file = $INSTALLDIR_CSM . "\/" . $temper_file;

        if (-e $temper_file)
        {
            my $exception =
              &copy_exceptions_rveg($distro_name, $temper_file);

            if ($exception == $::OK)
            {
                NodeUtils->runcmd("$::RM -rf $temper_file",                -2);
                NodeUtils->runcmd("$::COPY -pr $bin_file $INSTALLDIR_CSM", -2);
            }
        }
        else
        {
            my $exception =
              &copy_exceptions_rveg($distro_name, $bin_file);
            if ($exception == $::OK)
            {
                NodeUtils->runcmd("$::COPY -pr $bin_file $INSTALLDIR_CSM", -2);
            }
        }

    }

    #
    # copy the files in /opt/csm/install/sample_scripts to /csminstall/csm/scripts
    #
    NodeUtils->runcmd(
                    "$::COPY -p /opt/csm/install/sample_scripts/* $::SCRIPTDIR",
                    0);

    # Copy updateglibc scripts to /csminstall/csm/scripts if DistributionName is
    # RedHat
    #todo: only do copies of scripts with ._ if the nodegrp exists.
    #    if ( $pkginfo{'DistributionName'} eq "RedHat" )
    #    {
    #    NodeUtils->runcmd("$::COPY -p /opt/csm/install/scripts/installprereboot/updateglibc._RedHat80Nodes $::SCRIPTDIR/installprereboot/.", -2 );
    #    }

    if (( $pkginfo{'OSName'} eq "Linux" )
    && ( $::PLTFRM ne "AIX" ))
    {
        my $MS_Arch = `/bin/uname -m`;
        if (($MS_Arch =~ /ppc/) && ($pkginfo{'PkgArchitecture'} =~ /i.86/))
        {
            my $rpmdir = InstallUtils->getRPMSDir(
                        $osname,            # eg Linux or AIX (case sensitive)
                        $distro_name,       # eg RedHat or SuSE (case sensitive)
                        $distro_version,    # eg 7.3 or 5.2
                        $hw_arch,           # eg i386, ppc
                        );          #"Linux", $distname, $distvers, $arch);

            $::FIND = "/usr/bin/find";
            $::GREP = "/bin/grep";
            my $cmd;
            if ($distro_name =~ /RedHat/)
            {
                $cmd = "$::FIND $rpmdir/ -type f | $::GREP \'syslinux\'";
            }
            else
            {
                $cmd =
                  "$::FIND $::INSTALLDIR_CSMPKG -type f | $::GREP \'syslinux\'";
            }
            my $res = `$cmd`;
            chomp $res;

            if ($res ne "")
            {
                $res =
                  `rm -fr /tmp/dir4syslinux; mkdir -p /tmp/dir4syslinux; cd /tmp/dir4syslinux; $::RPM2CPIO $res | cpio -idu --quiet;`;
                my $cmd =
                  "$::FIND /tmp/dir4syslinux -type f | $::GREP \'pxelinux\.0\'";
                my $res = `$cmd`;
                chomp $res;
                @csm_bin_file_tftpboot = ($res);
            }
        }

        # Files to copy to /tftpboot
        my $cmd = "$::RPMCMD -qa | $::GREP syslinux";
	my $res = `$cmd`;
	my $version = (split("-", $res))[1];
	if ($version > "2.04")
	{
		$cmd= "$::RPMCMD -ql syslinux | $::GREP \'pxelinux\.0\'";
		$res = `$cmd`;
	        chomp $res;
		pop @csm_bin_file_tftpboot; 	
		@csm_bin_file_tftpboot = ($res);
	}	
	
	foreach my $bin_file (@csm_bin_file_tftpboot)
        {
            NodeUtils->runcmd("$::COPY $bin_file /tftpboot", -2);
        }

        # after files are copied, change the permission:
        InstallUtils->secureFilePermissions('/tftpboot', '0110', '0440');


        #files needed for RMC thin client which is used by the nodes to
        # communicate to the MS during install
        my $HW_ARCH = $pkginfo{'PkgArchitecture'};
        my $MS_ARCH = ArchiveUtils->get_PkgArchitecture();


        if ($MS_ARCH =~ /i.86/)  { $MS_ARCH = "i386"; }
        if ($MS_ARCH =~ /ppc64/) { $MS_ARCH = "ppc"; }
        if ($HW_ARCH =~ /ppc64/) { $HW_ARCH = "ppc"; }
        if ($HW_ARCH =~ /x86_64/)
        {
            $HW_ARCH = "i386";
        }    #Use i386 RPMs for x86_64
        if ($MS_ARCH =~ /x86_64/)
        {
            $MS_ARCH = "i386";
        }    #Use i386 RPMs for x86_64

        #print "NODE_ARCH = $HW_ARCH, MS_ARCH = $MS_ARCH\n";
        my $extractdir = "/";
        if ($HW_ARCH ne $MS_ARCH)
        {

            # Extract all the files from the rsct.core and rsct.core.utils rpms
            # into $extractdir

            my $rsct_rpm_filename;
            my $cmd;
            $extractdir = "/tmp/dir4rsctrpm";
            mkpath($extractdir, $::VERBOSE, 0755);
            $cmd = "$::RM -rf $extractdir/*";
            NodeUtils->runcmd($cmd);

            foreach my $rpm ("rsct.core", "rsct.core.utils")
            {
                $rsct_rpm_filename =
                    $::PathVersionName{$HW_ARCH}{$rpm}{"Location"} . "/"
                  . $::PathVersionName{$HW_ARCH}{$rpm}{"Longname"}
                  . ".${HW_ARCH}.rpm";

                #print "RPM NAME = $rsct_rpm_filename\n";
                if (!-f $rsct_rpm_filename)
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                       'csminstall', "E1", "EMsgFILE_NOT_FOUND",
                                       $rsct_rpm_filename);
                }

                $cmd =
                  "cd $extractdir; $::RPM2CPIO $rsct_rpm_filename | cpio -idu --quiet;";
                NodeUtils->runcmd($cmd, 0);
            }
        }
        my @files = (
                     "/usr/sbin/rsct/lib/libct_mc.so",
                     "/usr/sbin/rsct/lib/libct_cu.so",
                     "/usr/sbin/rsct/lib/libct_tr.so",
                     "/usr/sbin/rsct/lib/libct_pmsg.so",
                     "/usr/sbin/rsct/lib/libct_sec.so",
                     "/usr/sbin/rsct/lib/libct_idm.so",
                     "/usr/sbin/rsct/lib/libct_ffdc.so",
                     "/usr/sbin/rsct/cfg/ctsec.cfg",
                     "/usr/sbin/rsct/bin/runact-api",
                     );

        my $targetdir = "/csminstall/csm/$HW_ARCH";
        mkpath($targetdir, $::VERBOSE, 0755);

        foreach my $file (@files)
        {
            $file = "$extractdir$file";
            if (!-f $file)
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                       'csminstall', "E", "EMsgNO_CopyFile", $file, $targetdir);
            }
            else
            {
                NodeUtils->runcmd("$::COPY -p $file $targetdir", -2);
            }
        }
    }

    # Copies hardware control ucode files on AIX to /csminstall/AIX/ucode
    if ($pkginfo{'OSName'} eq "AIX")
    {
        if (!-e "/csminstall/AIX/ucode")
        {
            mkdir "/csminstall/AIX/ucode", 0077;
        }

        #NodeUtils->runcmd( "$::COPY -pr /opt/csm/install/ucode/ /csminstall/AIX/", -2);
    }

}

#--------------------------------------------------------------------------------

=head3 copy_csm_scripts

        This function copies customization scripts from /opt/csm/install/scripts/
        to /csminstall/csm/scripts.                                                            

        If the extension of the script matches a defined node group or there is
        no extension, then copy the script.

        If the $verify parameter is 1, this function checks the target dir if the
        scripts exist, if no, it will copy the scripts, otherwise, it will do
        nothing.  If the $verify parameter is 0,this function will always copy the
        scripts.

        Arguments:
                $verify  - either 1 or 0

        Returns:
                $::OK
                $::NOK
        Globals:
                $::NODEGRP
                $::PREINSTALLDIR
                $::POSTINSTALLDIR
                $::UPDATEDIR
        Error:
                csmInstall.cat 'E'_
        Example:
                ServerUtils->copy_csm_scripts(1);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub copy_csm_scripts
{

    my ($class, $verify) = @_;
    my $INSTALLPREREBOOT  = "/opt/csm/install/scripts/installprereboot";
    my $INSTALLPOSTREBOOT = "/opt/csm/install/scripts/installpostreboot";
    my $UPDATE            = "/opt/csm/install/scripts/update";

    my @groupname;
    my $targetdir;
    my $filename;
    my $basename;
    my $extension;
    my $junk;
    my $cmd;

    $cmd = "$::NODEGRP";
    @groupname = NodeUtils->runcmd($cmd, -1);
    if ($::RUNCMD_RC)
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  "E", 'EMsgCANT_RUN', $cmd, $::RUNCMD_RC);
        return $::NOK;
    }

    foreach my $dirname ($INSTALLPREREBOOT, $INSTALLPOSTREBOOT, $UPDATE)
    {
        if ($dirname eq $INSTALLPREREBOOT)
        {
            $targetdir = $::PREINSTALLDIR;
        }
        elsif ($dirname eq $INSTALLPOSTREBOOT)
        {
            $targetdir = $::POSTINSTALLDIR;
        }
        elsif ($dirname eq $UPDATE)
        {
            $targetdir = $::UPDATEDIR;
        }

        if (-d $dirname)
        {
            if (!-d $targetdir)
            {
                mkpath($targetdir, $::VERBOSE, 0755);
            }
            $cmd = "$::LS $dirname";
            my @filelist = NodeUtils->runcmd($cmd, -1);
            if ($::RUNCMD_RC)
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                         'csminstall', "E", 'EMsgCANT_RUN', $cmd, $::RUNCMD_RC);
                return $::NOK;
            }
            foreach $filename (sort @filelist)
            {
                chomp $filename;
                if (-d "$dirname/$filename")
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                            'csminstall', "I", 'IMsgSkipSubDir',
                                            "$dirname/$filename");
                    next;
                }

                if (!-x "$dirname/$filename")
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                            'csminstall', "E", 'EMsgSkipScript',
                                            "$dirname/$filename");
                    next;
                }
                if (-e "$targetdir/$filename")
                {

                    $cmd =
                      "/usr/bin/diff $dirname/$filename $targetdir/$filename";
                    my $temp = NodeUtils->runcmd($cmd, -1);
                    if ($temp)
                    {
                        if ($::VERBOSE)
                        {
                            NodeUtils->message('W', 'IMsgScriptUpdate',
                                               $filename);
                        }
                    }
                }

                ($basename, $extension, $junk) = split(/\._/, $filename);
                if (defined($junk)) { next; }
                if (!defined($extension) || grep(/^$extension$/, @groupname))
                {
                    if (   (!$verify)
                        || (($verify) && (!-e "$targetdir/$filename")))
                    {
                        $cmd = "$::COPY -f $dirname/$filename $targetdir";
                        NodeUtils->runcmd($cmd, -2);
                    }
                }
            }

        }
    }
    return $::OK;
}

#--------------------------------------------------------------------------------

=head3    create_directory_structure

       Creates the csminstall directory sturctuire on the Managment Server.

	Globls:

		Relies on $::PREREQS_ATTR variable for directory names

=cut

#--------------------------------------------------------------------------------

sub create_directory_structure
{

    NodeUtils->message('I', 'IMsgCreatingDirectories');
    mkpath($::INSTALLDIR_CSMVRBIN, $::VERBOSE, 0755);
    mkpath($::INSTALLDIR_CSMBIN,   $::VERBOSE, 0755);
    mkpath($::PREINSTALLDIR,       $::VERBOSE, 0755);
    mkpath($::POSTINSTALLDIR,      $::VERBOSE, 0755);
    mkpath($::UPDATEDIR,           $::VERBOSE, 0755);
    mkpath($::SCRIPTDATADIR,       $::VERBOSE, 0755);
    mkpath($::INSTALLDIR_CSMPKG,   $::VERBOSE, 0755);

    ArchiveUtils->createRPMSdir(
                                $::PREREQS_ATTR{'OSName'},
                                $::PREREQS_ATTR{'DistributionName'},
                                $::PREREQS_ATTR{'DistributionVersion'},
                                $::PREREQS_ATTR{'PkgArchitecture'}
                                );

    # we need the tftpboot directory.  But if it is a file then
    # we need the user to remove it:
    if (-f "/tftpboot")
    {
        NodeUtils->message('E2', 'EMsgNo_Directory', "\/tftpboot");
    }
    else
    {

        # now we can create the directory with the appropriate
        # permissions:
        mkpath("/tftpboot", $::VERBOSE, 0110);
    }
}

#--------------------------------------------------------------------------------

=head3    getBaseDir

        Get the base directory for the install
        attribute parameters

        Arguments:
                $InstallOSName
                $InstallDistributionName
                $InstallDistributionVersion
                $InstallPkgArchitectur
        Returns:
                approparite base directory for parameters
        Globals:
                none
        Error:
                undefined
        Example:
                $::DISTRO_TOP = ServerUtils->getBaseDir("Linux",
                                                        $::DISTRO_NAME,
                                                        $::DISTRO_VERSION,
                                                        $::ARCH);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getBaseDir
{
    my ($class, $os, $distributor, $version, $arch) = @_;
    if ($arch =~ /i.86/) { $arch = "i386"; }
    return "/csminstall/$os/$distributor/$version/$arch";
}

#--------------------------------------------------------------------------------

=head3    getInstallDir

        Returns the install directory path name for the Install Attribute
        parameters.

        Arguments:
                $InstallOSName
                $InstallDistributionName
                $InstallDistributionVersion
                $InstallPkgArchitectur
        Returns:
                Appropriate path name 
        Globals:
                none
        Error:
                undefined
        Example:
                unused
        Comments:
                unused??

=cut

#--------------------------------------------------------------------------------

sub getInstallDir
{
    my ($class, $os, $distributor, $version, $arch) = @_;
    if ($arch =~ /i.86/) { $arch = "i386"; }
    return "/csminstall/$os/$distributor/$version/$arch/install";
}

#--------------------------------------------------------------------------------

=head3    getUpdateDir

        Returns the update directory for the install
        attritbute parameters

        Arguments:
                $InstallOSName
                $InstallDistributionName
                $InstallDistributionVersion
                $InstallPkgArchitectur

        Returns:
                Appropriate path name of the attribute input
        Globals:
                none
        Error:
                undefined
        Example:
                my $updateDir =
                    ServerUtils->getUpdateDir($OS, $dist, $distver, $arch);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getUpdateDir
{
    my ($class, $os, $distributor, $version, $arch) = @_;
    if ($arch =~ /i.86/) { $arch = "i386"; }
    return "/csminstall/$os/$distributor/$version/$arch/updates";
}

#--------------------------------------------------------------------------------

=head3    mk_link_for_addlcsext

          Creates a symbolic link needed by addlcsext to run on ms w/o -p flag
          (Called from down under installms, but never from copycsmpkgs) 

        Arguments:
                None

        Returns:
                none
        Globals:
                $::PREREQS_ATTR
                $::ATTRS
                $::LCSEXT
                $::INSTALLDIR_CSMPKG
        Error:
                E2, EMsgINVALID_OSTYPE
        Example:
                    ServerUtils->mk_link_for_addlcsext;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub mk_link_for_addlcsext
{
    if (   ($::PREREQS_ATTR{'OSName'} eq "Linux")
        || ($::ATTRS{'InstallOSName'} eq "Linux"))
    {

        # Link the packages directory to a location that addlcsext can use with its default -p
        if ($::LCSEXT eq "true")
        {
            my $cmd;
            if (!-d "/opt/csm/lcsext")
            {
                $cmd = "$::MKDIR /opt/csm/lcsext";
                NodeUtils->runcmd($cmd, 0);
            }
            else
            {
                $cmd = "$::RM /opt/csm/lcsext/packages";
                NodeUtils->runcmd($cmd, 0);
            }
            $cmd = "$::LN -sf $::INSTALLDIR_CSMPKG /opt/csm/lcsext/packages";
            NodeUtils->runcmd($cmd, 0);
        }
    }
    elsif ($::PREREQS_ATTR{'OSName'} eq "AIX") { }
    else { NodeUtils->message('E2', 'EMsgINVALID_OSTYPE'); }
}

#--------------------------------------------------------------------------------

=head3    returnSubdirectory

        Returns all the sub directories of the input parameter.

        Arguments:
                $directoryName
                $validDir - (optional) value of 1 if defined
        Returns:
                array of subdirectory names     
        Globals:
                $::PLTFRM
        Error:
                undefined
        Example:
                 push   @::PKGPATH,
                        (ServerUtils->returnSubdirectory($p));
        Comments:
                the $validDir parameter, when set to 1 checks if the 
                parent directory to the $directoryName parmeter is valid. 

=cut

#--------------------------------------------------------------------------------

sub returnSubdirectory
{
    my ($class, $dir, $valid_dir) = @_;
    my $file;
    my @subdirs       = ();
    my @returndirs    = ();
    my @valid_subdirs = ();    #these are ones whose children we can look at
    if ($::PLTFRM eq "AIX")
    {
        if ($dir =~ m/(installp.?\z)|(usr.?\z)|(RPMS.?\z)/)
        {                      #check to see if the parent is valid
            $valid_dir = 1;
        }
    }
    opendir(DIRECTORY, $dir) or return ();
    while ($file = readdir(DIRECTORY))
    {
        if ($file ne '.' and $file ne '..')
        {
            my $filename;
            if ($dir =~ /\/\z/)
            {                  #if it ends with a slash
                $filename = "$dir$file";
            }
            else
            {                  #no slash
                $filename = "$dir/$file";
            }
            if ((-d "$filename") && ($::PLTFRM eq "AIX"))
            {
                if (!$valid_dir)
                {              #the parent wasn't an valid directory
                    if (   ($file eq "installp")
                        || ($file eq "usr")
                        || ($file eq "RPMS"))
                    {
                        push @valid_subdirs, $filename;
                    }
                }
                else
                {    #a valid parent, so therefore its children are valid too
                    push @valid_subdirs, $filename;
                }

            }
        }
    }
    closedir(DIRECTORY);
    push @returndirs, @valid_subdirs;
    push @returndirs, @subdirs;
    foreach my $sub (@valid_subdirs)
    {                #these are valid children
        my @tmpdirs = InstallUtils->returnSubdirectory($sub, 1);
        push @returndirs, @tmpdirs;
    }
    return @returndirs;
}

#--------------------------------------------------------------------------------

=head2    File Layer

=cut

#--------------------------------------------------------------------------------

=head3    CreateRandomName

        Create a randome file name.

        Arguments:
                Prefix of name
        Returns:
                Prefix with 8 random letters appended
        Error:
                none
        Example:
                $file = ServerUtils->CreateRandomName($namePrefix);
        Comments:
                None

=cut

#--------------------------------------------------------------------------------

sub CreateRandomName
{

    my ($class, $name) = @_;

    my $nI;
    for ($nI = 0 ; $nI < 8 ; $nI++)
    {
        my $char = ('a' .. 'z', 'A' .. 'Z')[int(rand(52)) + 1];
        $name .= $char;
    }
    $name;
}

#--------------------------------------------------------------------------------

=head3    create_nodemap_file

        Create /csminstall/csm/config/nodemap file that contains a mapping
        of ManagedNode hostnames as defined in the CSM database, and node hostnames
        as returned by the hostname command. 

        Arguments:
                 $ref_nodeList
                 $ref_nodeInfo
                 $ref_DestNodeHash
        Returns:
                $::OK
                $::NOK
        Globals:
                $::NODE_LIST_FILE
        Error:
                $::NOK
        Example:
                if( ServerUtils->create_nodemap_file ( \@::NODELIST,
                                                        \@::LSNODE_INFO,
                                                        \%::NODEHASH) != 0){
                    blah;
                }
        Comments:
                File format -  csm_hostname<space>node_hostname    

=cut

#--------------------------------------------------------------------------------

sub create_nodemap_file
{
    my ($class, $ref_nodelist, $ref_nodeinfo, $ref_DestNodeHash) = @_;
    my @nodelist = @$ref_nodelist;
    my @nodeinfo = @$ref_nodeinfo;

    #  DestNodeHash is a hash containing attribute values for each node
    #    that was provided on the command line.
    my %DestNodeHash = %$ref_DestNodeHash;
    %main::dsh_failed = ();
    my ($cmd,          @dshout,  $rc);
    my ($csm_nodename, $csmnode, $hostname);
    my $csmcfgdir    = "/csminstall/csm/config";
    my $nodemap_file = "/csminstall/csm/config/nodemap";
    my $node;
    my $dshresult = "";

    #
    #  Check and/or create the /csminstall/csm/config directory
    #
    if (!-d $csmcfgdir)
    {
        $cmd = "$::MKDIR -m 755 -p $csmcfgdir";
        $rc  = system("$cmd");
        if ($rc >> 8)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',   $::MSGMAPPATH,
                                      'csminstall',       "E",
                                      'EMsgNO_CreateDir', $csmcfgdir
                                      );
            return ($::NOK);
        }
    }

    # Remove any old occurences of the nodemap file
    if (-f $nodemap_file)
    {
        $cmd = "$::RM $nodemap_file";
        $rc  = system("$cmd") >> 8;
        if ($rc != 0)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall',     "E",
                                      'EMsgNO_RM',      "$nodemap_file"
                                      );

            # try to continue
        }
    }

    # open the map file
    unless (open(NODEMAP, ">$nodemap_file"))
    {

        # print error message
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',      $::MSGMAPPATH,
                                  'csminstall',          "E",
                                  'EMsgCANT_WRITE_FILE', "$nodemap_file"
                                  );
        return $::NOK;
    }
    my @AIX;
    my @Linux;
    my %found = ();
    my %dups  = ();

    # for each node in the node list
    foreach $node (keys %DestNodeHash)
    {

        # set the correct command based on the InstallOSName
        if (defined($DestNodeHash{$node}{'InstallOSName'}))
        {
            if ($DestNodeHash{$node}{'InstallOSName'} eq "AIX")
            {

                #$dshcmd = "$::DSH -n$node hostname";
                push @AIX, $node;
            }
            elsif ($DestNodeHash{$node}{'InstallOSName'} eq "Linux")
            {

                #$dshcmd = "$::DSH -n$node hostname -f";
                push @Linux, $node;
            }
        }
    }
    if (@Linux)
    {
        my $node_file =
          InstallUtils->make_node_list_file(\@Linux)
          ;    #put all dest nodes in tmp file
        $ENV{'DSH_LIST'} = $node_file;
        my $dshcmd    = "$::DSH hostname -f";
        my @dshresult = `$dshcmd`;
        $rc = $? >> 8;
        InstallUtils->close_delete_file($::NODE_LIST_FILE, $node_file)
          ;    #delete node file
        if ($rc != 0)
        {

            # print error message
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',    $::MSGMAPPATH,
                                      'csminstall',        'E',
                                      'EMsgCMD_FAILED_RC', $dshcmd,
                                      $rc
                                      );

            #$main::dsh_failed{$node}=1; #take these out of target nodes
            #next;
        }
        foreach my $line (@dshresult)
        {
            my ($csmnode, $hostname) = split(" ", $line);
            $hostname =~ s/://g;
            $csmnode  =~ s/://g;
            if (defined($csmnode) && defined($hostname))
            {

                # make sure the format is consistent with the name that
                #     was used to create the configinfo file
                #$csm_nodename = NodeUtils->tryHost($csmnode);
                $found{$csmnode} = 1;
                $dups{$hostname}{$csmnode} = 1;

                # put the result in the nodemap file
                unless (print NODEMAP "$csmnode $hostname\n")
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall', 'E', 'EMsgCANT_WRITEtoFILE',
                                      "$nodemap_file");
                }
            }
        }
    }
    if (@AIX)
    {
        my $node_file =
          InstallUtils->make_node_list_file(\@AIX)
          ;    #put all dest nodes in tmp file
        $ENV{'DSH_LIST'} = $node_file;
        my $dshcmd    = "$::DSH hostname";
        my @dshresult = `$dshcmd`;
        $rc = $? >> 8;
        InstallUtils->close_delete_file($::NODE_LIST_FILE, $node_file)
          ;    #delete node file
        if ($rc != 0)
        {

            # print error message
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',    $::MSGMAPPATH,
                                      'csminstall',        'E',
                                      'EMsgCMD_FAILED_RC', $dshcmd,
                                      $rc
                                      );

            #$main::dsh_failed{$node}=1; #take these out of target nodes
            #next;
        }
        foreach my $line (@dshresult)
        {
            my ($csmnode, $hostname) = split(" ", $line);
            $hostname =~ s/://g;
            $csmnode  =~ s/://g;
            if (defined($csmnode) && defined($hostname))
            {

                # make sure the format is consistent with the name that
                #     was used to create the configinfo file
                #$csm_nodename = NodeUtils->tryHost($csmnode);
                $found{$csmnode} = 1;
                $dups{$hostname}{$csmnode} = 1;

                # put the result in the nodemap file
                unless (print NODEMAP "$csmnode $hostname\n")
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall', 'E', 'EMsgCANT_WRITEtoFILE',
                                      "$nodemap_file");
                }
            }
        }
    }

    #foreach my $n (keys %DestNodeHash){
    #    if(!$found{$n}){
    #        $main::dsh_failed{$n}=1;
    #    }
    #    }
    foreach my $n (keys %dups)
    {    #get rid of any nodes that map to the same hostname
        if (scalar(keys %{$dups{$n}}) > 1)
        {
            my @dupNodes = keys %{$dups{$n}};
            my $dNstring = join ',', @dupNodes;
            my $hostname = $n;
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',  $::MSGMAPPATH,
                                      'csminstall',      'E',
                                      'EMsgHostnameMap', $hostname,
                                      $dNstring
                                      );
            foreach my $d (@dupNodes)
            {
                $main::dsh_failed{$d} = 1;
            }
        }
    }
    close(NODEMAP);
    if (!@AIX && !@Linux)
    {
        return $::NOK;
    }
    return $::OK;
}

#--------------------------------------------------------------------------------

=head3    createSMSConfig

        Put SMS node group info into the file:
        /csminstall/csm/var/smsupdate.info

        Arguments:
                none
        Returns:
                reference to a hash of all groups
        Globals:
                none
        Error:
                NodeUtil message E
        Example:
                 #create the SMS nodegroup config file
                 ServerUtils->createSMSConfig();
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub createSMSConfig
{
    my %all_groups = ();
    my %node_index;
    my @empty_array = ();
    if (-e "/csminstall")
    {
        if (!-e "/csminstall/csm")
        {
            mkdir "/csminstall/csm",        0077;
            mkdir "/csminstall/csm/config", 0077;
        }
    }
    my $ref_nodegrp = NodeUtils->listNodeGroupExpMem(@empty_array);
    foreach my $row (@$ref_nodegrp)
    {
        my ($groupname, $nodelist) = $row =~ /^(.+):\|:\{(.*)\}$/;
        my @nodes = split(/,/, $nodelist);
        foreach my $node (@nodes)
        {
            push @{$node_index{$node}},      $groupname;
            push @{$all_groups{$groupname}}, $node;

        }
    }
    system("$::MKDIR -p /csminstall/csm/config/");
    open(GROUPFILE, ">/csminstall/csm/config/sms.info")
      or NodeUtils->message('E', 'EMsgCANT_OpenFile',
                            "/csminstall/csm/config/sms.info",
                            "$? $!");
    foreach my $node (keys %node_index)
    {
        print GROUPFILE "$node: @{$node_index{$node}} \n";
    }
    close GROUPFILE;
    return \%all_groups;
}

#--------------------------------------------------------------------------------

=head3 get_script_list

        For a given directory get a list of scripts and associated list
        of nodes to run it on.

        Arguments:
                $directoryName
                 @nodeList
        Returns:
                $::OK
                $::NOK 
        Globals:
                @::scriptlist
                @{$::scriptnodes{$fname}}
                
        Error:
                $::NOK 
        Example:
                $rc = ServerUtils->get_script_list($dirname,@nodelist);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_script_list
{
    my ($junk, $dirname, @nlist) = @_;
    my %basename;
    my $target;
    my $filename;
    my @filelist;
    my $cmd;

    @::scriptlist = ();

    if (-d $dirname)
    {
        $cmd = "$::LS $dirname";
        @filelist = NodeUtils->runcmd($cmd, -1);
        if ($::RUNCMD_RC)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall',     "E",
                                      'EMsgCANT_RUN',   $cmd,
                                      $::RUNCMD_RC
                                      );
            return $::NOK;
        }
    }
    else
    {

        # msg - Warning: The \'$dirname\' does not exist.
        #        Skipping to the next directory.
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  "E", 'EMsgSkipDir', $dirname);
        return $::NOK;
    }

    # check each script name in this directory
    # - add the filename to the script list
    # - get the initial list of node to run the script on
    # - save the basename for each script
    foreach $filename (sort @filelist)
    {
        chomp $filename;

        #  make sure this is not a subdir
        if (-d "$dirname/$filename")
        {

            # error - Skipping subdirectory $dirname/$filename.
            NodeUtils->messageFromCat(
                                      'csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall',     "I",
                                      'IMsgSkipSubDir', "$dirname/$filename"
                                      );
            next;
        }

        # figure out what nodes to run the script on by
        #    deciphering the script name
        @{$::scriptnodes{$filename}} =
          InstallUtils->name2list($dirname, $filename, @nlist);
        if (${$::scriptnodes{$filename}}[0] eq $::NOK)
        {

            # msg - Skipping to the next script name.
            NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall', "E", 'EMsgSkipScript');
            next;
        }
        push @::scriptlist, $filename;
        (@basename{$filename}, $target) = split(/\._/, $filename);
    }

    # now check each script that has no extension (target) and see
    #  if there are any scripts with the same basename that have targets
    # if there are - remove any nodes in the targeted script list from the
    #  list of nodes for the script with no extensions(target)
    # ex.  say script foo goes to all nodes and script foo._grpa goes
    # to node1 & node2.  In this case I need to remove node1 & node2
    # from the list of nodes for the script foo.

    foreach my $fname (sort @::scriptlist)
    {
        chomp $fname;

        # if the script name is the same as the basename then
        #   the list is all the nodes passed in on the command line.
        if ($fname eq @basename{$fname})
        {

            # check the rest of the scripts to see if any
            # have the same basename - if we find one then redo
            # the list for the basename-only script
            foreach my $file (@::scriptlist)
            {
                chomp $file;

                #  see if the basenames are the same
                if (@basename{$fname} eq @basename{$file})
                {

                    # don't remove itself
                    if ($file ne $fname)
                    {
                        my @tmplist = ();
                        foreach my $node (@{$::scriptnodes{$fname}})
                        {

                            # if the node is not in the list for $file
                            #  then add it to a temp list
                            if (!grep /^$node/, @{$::scriptnodes{$file}})
                            {
                                push @tmplist, $node;
                            }
                        }
                        @{$::scriptnodes{$fname}} = @tmplist;
                    }
                }
            }
        }
    }
    return $::OK;
}

#--------------------------------------------------------------------------------

=head3    make_config_file

        Create configuration information files for each node provided
        in the nodelist reference argument.

        Arguments:
                 $ref_nodeList
                 $ref_nodeinfo
                 $ref_DestinationNodeHash
        Returns:
                $::OK
                $::NOK
        Globals:
                $::SETUP_REMOTE_SHELL
                $::NOSMS
        Error:
                $::NOK
        Example:
                if(ServerUtils->make_config_file( \@DestNode,
                                                   \@lsnode_info,
                                                   \%DestNodeHash) != 0) {
                    blah;
                }
        Comments:
                Requires $::REMOTE_SHELL and $::SETUP_REMOTE_SHELL to be set optionally,
                $::NOSMS can be set to instruct makenode to not perform software maintenance
                on Linux nodes

=cut

#--------------------------------------------------------------------------------

sub make_config_file
{

    my ($class, $ref_nl, $ref_nodeinfo, $ref_DestNodeHash) = @_;
    my @nl       = @$ref_nl;
    my @nodeinfo = @$ref_nodeinfo;

    #  DestNodeHash is a hash containing attribute values for each node
    #    that was provided on the command line.
    my %DestNodeHash = %$ref_DestNodeHash;

    my ($hname, $short, $rc);
    my $csmcfgdir = "/csminstall/csm/config";
    my $cmd;
    my $output;
    my $DirectorInstalled = 0;
    my ($host, $ipaddr, $shorthost);

    #
    #  Check and/or create the /csminstall/csm/config directory
    #
    if (!-d $csmcfgdir)
    {
        $cmd = "$::MKDIR -m 755 -p $csmcfgdir";
        $rc  = system("$cmd");
        if ($rc >> 8)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',   $::MSGMAPPATH,
                                      'csminstall',       "E",
                                      'EMsgNO_CreateDir', $csmcfgdir
                                      );
            return ($::NOK);
        }
    }

    # If this is a Linux management server, check if csm.director.agent
    # is installed.
    if (NodeUtils->isLinux() == 1)
    {
        $cmd = "$::RPMCMD -q csm.director.agent";
        $output = NodeUtils->runcmd($cmd, -1);
        if ($::RUNCMD_RC == 0)
        {
            $DirectorInstalled = 1;
        }
    }

    # get the lists of user-provided cstomization script
    #   that we need to run on the nodes
    if (InstallUtils->make_script_lists(@nl))
    {

        # msg  -Could not get lists of customization scripts
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  "E", 'EMsgNoCustScripts');

        # continue
    }

    #
    # create the config_info file
    #

    #  go through each node in the list
    #   (the keys are the hostnames as returned from tryHost() !!)
    foreach $hname (keys %DestNodeHash)
    {

        # remove the old config file if any
        if (-e "$csmcfgdir/$hname.config_info")
        {
            $cmd = "$::RM $csmcfgdir/$hname.config_info";
            $rc  = system("$cmd");
            if ($rc >> 8)
            {
                my $fn = "$csmcfgdir/$hname.config_info";
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                         'csminstall', "E", 'EMsgNO_RM', "$fn");

                # try to continue ??return $::NOK;
            }
        }

        # create the new file
        unless (open(CONFIG_OUT, ">$csmcfgdir/$hname.config_info"))
        {
            my $fn = "$csmcfgdir/$hname.config_info";
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',      $::MSGMAPPATH,
                                      'csminstall',          "E",
                                      'EMsgCANT_WRITE_FILE', "$fn"
                                      );
            return $::NOK;
        }

        # Add cluster-wide configuration information to the file
        if (defined($::REMOTE_SHELL))
        {
            print CONFIG_OUT "RemoteShell=$::REMOTE_SHELL\n";
        }
        if (defined($::SETUP_REMOTE_SHELL))
        {
            print CONFIG_OUT "SetupRemoteShell=$::SETUP_REMOTE_SHELL\n";
        }

        # add the node configuration information to the file
        if (defined($hname))
        {
            print CONFIG_OUT "Hostname=$hname\n";
        }
        if (defined($DestNodeHash{$hname}{'ManagementServer'}))
        {
            print CONFIG_OUT
              "ManagementServer=$DestNodeHash{$hname}{'ManagementServer'}\n";
            print CONFIG_OUT "ManagementServerIP="
              . NetworkUtils->validate_ip(
                                      $DestNodeHash{$hname}{'ManagementServer'})
              . "\n";
        }
        if (defined($DestNodeHash{$hname}{'InstallOSName'}))
        {
            print CONFIG_OUT
              "InstallOSName=$DestNodeHash{$hname}{'InstallOSName'}\n";
        }
        if (defined($DestNodeHash{$hname}{'InstallCSMVersion'}))
        {
            print CONFIG_OUT
              "InstallCSMVersion=$DestNodeHash{$hname}{'InstallCSMVersion'}\n";
        }
        if (defined($DestNodeHash{$hname}{'InstallDistributionVersion'}))
        {
            print CONFIG_OUT
              "InstallDistributionVersion=$DestNodeHash{$hname}{'InstallDistributionVersion'}\n";
        }
        if (defined($DestNodeHash{$hname}{'InstallDistributionName'}))
        {
            print CONFIG_OUT
              "InstallDistributionName=$DestNodeHash{$hname}{'InstallDistributionName'}\n";
        }
        if (defined($DestNodeHash{$hname}{'InstallPkgArchitecture'}))
        {
            print CONFIG_OUT
              "InstallPkgArchitecture=$DestNodeHash{$hname}{'InstallPkgArchitecture'}\n";
        }
        if (defined($DestNodeHash{$hname}{'Mode'}))
        {
            print CONFIG_OUT "Mode=$DestNodeHash{$hname}{'Mode'}\n";
        }
        if (defined($DestNodeHash{$hname}{'ConsoleSerialDevice'}))
        {
            print CONFIG_OUT
              "ConsoleSerialDevice=$DestNodeHash{$hname}{'ConsoleSerialDevice'}\n";
        }
        if (defined($DestNodeHash{$hname}{'InstallServer'})
            && ($DestNodeHash{$hname}{'InstallServer'} ne ""))
        {
            my $progname = NodeUtils->programName();
            if ($progname =~ m/installnode/)
            {

                #make sure a machine is not an install server of itself
                my ($node_hostname, $node_ip) = NodeUtils->getHost($hname);
                my ($server,        $rep_dir) = split ':',
                  $DestNodeHash{$hname}{'InstallServer'};
                my ($isvr_hostname, $isvr_ip) = NodeUtils->getHost($server);
                if ($node_hostname ne $isvr_hostname)
                {
                    print CONFIG_OUT
                      "InstallServer=$DestNodeHash{$hname}{'InstallServer'}\n";
                }
            }
            elsif ($DestNodeHash{$hname}{'InstallServer'} ne
                   $DestNodeHash{$hname}{'ManagementServer'})
            {

                #not using the ms as the install server
                print CONFIG_OUT
                  "InstallServer=$DestNodeHash{$hname}{'InstallServer'}\n";
            }
        }

        if (defined($DestNodeHash{$hname}{'PowerMethod'}))
        {
            print CONFIG_OUT
              "PowerMethod=$DestNodeHash{$hname}{'PowerMethod'}\n";
        }

        if (defined($DestNodeHash{$hname}{'InstallAdapterMacaddr'}))
        {
            print CONFIG_OUT
              "InstallAdapterMacaddr=$DestNodeHash{$hname}{'InstallAdapterMacaddr'}\n";
        }

        # Handle Linux-specific attributes.
        if ($DestNodeHash{$hname}{'InstallOSName'} eq "Linux")
        {

            # If csm.director.agent is installed on the management server,
            # then install it on the Linux nodes.
            print CONFIG_OUT "InstallDirector=$DirectorInstalled\n";

            # if $::NOSMS isn't set then perform software maintenance
            if (!$::NOSMS)
            {
                print CONFIG_OUT "SMS=1\n";
            }
        }

        if (defined($DestNodeHash{$hname}{'ConsoleSerialSpeed'}))
        {
            print CONFIG_OUT
              "ConsoleSerialSpeed=$DestNodeHash{$hname}{'ConsoleSerialSpeed'}\n";
        }

        if (defined($DestNodeHash{$hname}{'InstallMethod'}))
        {
            print CONFIG_OUT
              "InstallMethod=$DestNodeHash{$hname}{'InstallMethod'}\n";
        }

        # put in the SetupKRB5 attribute value
        if (!defined $::KRB5SETUP)
        {

            $::KRB5SETUP = InstallUtils->getSetupKRB5;
        }
        print CONFIG_OUT "SetupKRB5=$::KRB5SETUP\n";

        # put in what would be the KRB5 principal name for ManagementServer
        if (!defined $::MSNAME)
        {
            $::MSNAME = NodeUtils->getRSCThostname;
        }
        my $msnamelower = lc($::MSNAME);
        print CONFIG_OUT "CSMKRB5Principal=ctsrcmdp.$msnamelower";

        # put in what would be the KRB5 principal name for HA ManagementServer
        if (!defined $::HAMODE)
        {
            my $outref =
              NodeUtils->runrmccmd('lsrsrc-api', "-i",
                                   "-s IBM.DmsCtrl::::HAMode");
            $::HAMODE = $$outref[0];
        }
        if ($::HAMODE == 1)
        {    #on an active HAMS management server
            require HAMS;
            my $inactivems      = HAMS->getInactiveRSCTHostname(); # get HA name
            my $inactivemslower = lc($inactivems);
            print CONFIG_OUT ",ctsrcmdp.$inactivemslower\n";

        }
        else
        {
            print CONFIG_OUT "\n";
        }

        if (($::SETUP_REMOTE_SHELL == 1) && ($::REMOTE_SHELL =~ m/rsh/))
        {
            if (!defined $::HAMODE)
            {
                my $outref =
                  NodeUtils->runrmccmd('lsrsrc-api', "-i",
                                       "-s IBM.DmsCtrl::::HAMode");
                $::HAMODE = $$outref[0];
            }
            if ($::HAMODE == 1)
            {    #on an active HAMS management server
                    #get management server attribute for node on other ms
                require HAMS;
                my $other_ms = HAMS->getManagementServerAttr($hname);
                if ($other_ms)
                {
                    print CONFIG_OUT "InActiveMSAttr=$other_ms\n";
                }
            }
        }

        #
        # add the /etc/hosts info for the management server - just AIX for now
        #
        if ($DestNodeHash{$hname}{'InstallOSName'} eq "AIX")
        {
            ($host, $ipaddr) =
              NodeUtils->getHost($DestNodeHash{$hname}{'ManagementServer'});
            ($shorthost = $host) =~ s/\..*$//;
            print CONFIG_OUT "ETCHOSTSMS=$ipaddr $host $shorthost\n";
        }

        # add lists of scripts to run on the node
        if (defined(@{$::PREINSTSCRIPTS{$hname}}))
        {
            print CONFIG_OUT "PREINSTSCRIPTS=@{$::PREINSTSCRIPTS{$hname}}\n";
        }
        if (defined(@{$::POSTINSTSCRIPTS{$hname}}))
        {
            print CONFIG_OUT "POSTINSTSCRIPTS=@{$::POSTINSTSCRIPTS{$hname}}\n";
        }
        if (defined(@{$::UPDATESCRIPTS{$hname}}))
        {
            print CONFIG_OUT "UPDATESCRIPTS=@{$::UPDATESCRIPTS{$hname}}\n";
        }

        close(CONFIG_OUT);

        $cmd = "$::CHMOD 644 $csmcfgdir/$hname.config_info";
        $rc  = system("$cmd");
        if ($rc >> 8)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',    $::MSGMAPPATH,
                                      'csminstall',        'E',
                                      'EMsgCMD_FAILED_RC', $::CHMOD,
                                      $rc
                                      );

            # try to continue
        }

        #Add symbol link short_hostname.config_info to long_hostname.config_info
        my ($short_hname) = split('\.', $hname);

        # this symbolic link will be done only when the short name is not the
        # same as the long name
        if ($short_hname ne $hname)
        {
            $cmd =
              "cd $csmcfgdir; $::LN -fs $hname.config_info $short_hname.config_info";
            $rc = system("$cmd");
            if ($rc >> 8)
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                            'csminstall', 'E', 'EMsgCMD_FAILED_RC', $::LN, $rc);
            }
        }

    }    # go do the next node

    return $::OK;
}

#--------------------------------------------------------------------------------

=head3    make_node_list_file

        Makes a node list file.  

        Arguments:
                (\@list_of_nodes) - reference to an arrary of nodes.
        Returns:
                $file_name and sets the global var: $::NODE_LIST_FILE
        Globals:
                the ENV vars: DSH_LIST,  RPOWER_LIST,  RCONSOLE_LIST
        Error:
                None documented
        Example:
                ServerUtils->make_node_list_file(\@nodelist); 

        Comments:
                IMPORTANT:
          Make sure to cleanup afterwards with:

                         ServerUtils->close_delete_file($file_handle, $file_name)

=cut

#--------------------------------------------------------------------------------

sub make_node_list_file
{
    my ($class, $ref_node_list) = @_;
    my @node_list = @$ref_node_list;
    srand(time | $$);    #random number generator start

    my $file = "/tmp/csm_$$";
    while (-e $file)
    {
        $file = InstallUtils->CreateRandomName($file);
    }

    open($::NODE_LIST_FILE, ">$file")
      or
      NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                "E", 'EMsgCANT_WRITE_FILE', "$file");
    foreach my $node (@node_list)
    {
        print $::NODE_LIST_FILE "$node\n";
    }
    return $file;
}

#--------------------------------------------------------------------------------

=head3    make_script_lists

        Create lists of pre-install, post-install and update scrips
        for each node and put them in the following global hashes:

        %::PREINSTSCRIPTS - scripts get run from csmprereboot
                        during full install before the first reboot.
        %::POSTINSTSCRIPTS - scripts get run from csmfirstboot
                        after the first reboot of the system.
        %::UPDATESCRIPTS - scripts get run from updatenode.client
                        after a node has been updated.

        Arguments:
                @nodelist
        Returns:
                $::OK   - on success
                1       - on error
        Globals:
                %::PREINSTSCRIPTS
                %::POSTINSTSCRIPTS 
                %::UPDATESCRIPTS
        Example:
                if( ServerUtils->make_script_lists(@nodelist) ) { blah; }_
        Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub make_script_lists
{

    my ($junk, @nodel) = @_;   # the list of nodes passed in on the command line
    my $dirname;               #  directory to check for scripts
    my $script;                #  unique script name
    my $cmd;
    my $rc;

    @::scriptlist;             #  list of scripts found in a directory
    %::scriptnodes;            #  lists of nodes to run each script on

    # get the list of all nodes so we can check
    #       for valid node names later
    $cmd = "$::LSNODE";
    @::allnodes = NodeUtils->runcmd($cmd, -1);
    if ($::RUNCMD_RC)
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E', 'EMsgCANT_RUN', $cmd, $::RUNCMD_RC);
        return $::NOK;
    }

    my @scriptdirlist;
    if ($::UPDATESCRIPTSONLY)
    {
        @scriptdirlist = ($::UPDATEDIR);
    }
    else
    {
        @scriptdirlist = ($::PREINSTALLDIR, $::POSTINSTALLDIR);
    }

    # check each subdirectory for user scripts
    foreach $dirname (@scriptdirlist)
    {

        $rc = InstallUtils->get_script_list($dirname, @nodel);

        if ($rc == $::NOK)
        {
            next;
        }

        # check each script name in this directory
        foreach $script (sort @::scriptlist)
        {
            chomp $script;

            # see if there are any nodes in the list
            if (@{$::scriptnodes{$script}}[0] eq $::NOK)
            {

                # msg - Skipping to the next script name.
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                          'csminstall', "E", 'EMsgSkipScript');
                next;
            }

            # see if the script is executable
            if (!(-x "$dirname/$script"))
            {

                # msg - Script $script is not executable.
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                       'csminstall', "E", 'EMsgExecScript', "$dirname/$script");

                # msg - Skipping to the next script name.
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                          'csminstall', "E", 'EMsgSkipScript');
                next;
            }

            #  add the file to the correct script list for the node
            foreach my $node (@{$::scriptnodes{$script}})
            {

                chomp $node;

                if ($dirname eq $::PREINSTALLDIR)
                {
                    push @{$::PREINSTSCRIPTS{$node}}, $script;

                }
                elsif ($dirname eq $::POSTINSTALLDIR)
                {
                    push @{$::POSTINSTSCRIPTS{$node}}, $script;

                }
                elsif ($dirname eq $::UPDATEDIR)
                {
                    push @{$::UPDATESCRIPTS{$node}}, $script;
                }
            }
        }
    }
    return $::OK;
}

#--------------------------------------------------------------------------------

=head3    name2list

        Convert a script file name to a list of nodes that the
        script can be run on.

        Arguments:
                $dirname,
                $filename
                @nlist
        Returns:
                array of node names.
        Error:
                1 - An error occured.                                   #
        Globals:
                
                Requires @::allnodes be set by caller
        Example:
                @{$::scriptnodes{$filename}}=
                        ServerUtils->name2list($dirname,$filename,@nlist);_
        Comments:
                The file name format is <basename>._<node or group>.
                If there is just a basename then it applies to all nodes.
                If there is a node name then it just applies to that node.
                If there is a group name then it applies to the members of
                the group.


=cut

#--------------------------------------------------------------------------------

sub name2list
{
    my ($junk, $dirname, $filename, @nlist) = @_;
    my @nodelist = ();
    my ($base,  $name,   @glist);
    my ($short, $target, $cmd);
    my $junk2;

    chomp $filename;

    # the second part of the file name tells us
    #    what nodes to run it on
    # also check if additional target was used - error
    ($base, $target, $junk2) = split(/\._/, $filename);

    if (defined($junk2))
    {

        #  \'$filename\' is not a valid customization script name.
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',    $::MSGMAPPATH,
                                  'csminstall',        "E",
                                  'EMsgBadScriptName', "$dirname/$filename"
                                  );
        return $::NOK;
    }

    if (!defined($target))
    {

        # do on all nodes the calling
        #    command was asked to process
        return @nlist;

    }
    else
    {

        # see if the target is a valid node name
        my ($hostname, $ipaddr) = NodeUtils->tryHost($target);
        if (grep(/^$hostname/, @::allnodes))
        {

            # see if the target is one of the nodes
            #     specified on the command line
            if (grep(/^$hostname/, @nlist))
            {
                chomp(@nodelist = ($hostname));
            }
            return @nodelist;
        }

        # see if target is a valid group name
        $cmd = "$::NODEGRP -p $target";
        @glist = NodeUtils->runcmd($cmd, -1);
        if ($::RUNCMD_RC)
        {

            # msg - An incorrect file name format was used for the script $filename. '$target' is neither a node name nor a group name.
            NodeUtils->messageFromCat(
                                      'csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall',     "E",
                                      'EMsgBadScript',  "$dirname/$filename",
                                      $target
                                      );
            return $::NOK;

        }
        else
        {

            foreach $name (@glist)
            {

                # we only need a node if it was specified
                #    on the command line
                if (grep(/^$name/, @nlist))
                {
                    push(@nodelist, $name);
                }
            }
            return @nodelist;
        }
    }
    return $::NOK;
}

#--------------------------------------------------------------------------------

=head2    PkgDefs Support

=cut

#--------------------------------------------------------------------------------

=head3    get_OSDefs

        Determine which definition files need to be loaded and
        load them.  Read the set of OSDefs variables into a hash
        and assigns them each to global variables.  Calls get_osdefs_files
        to read the files in /opt/csm/install/defs.  The correct file(s)
        are chosen based on the parameters passed in to get_OSDefs.

        If no parameters are provided, default values based on the current
        machine's configuration are filled in.

        Arguments:
                $argsProvided.
        Returns:
                Array of defintion file names
        Globals:
                none
        Error:
                undefined
        Example:
                my %osdefs =
                   ServerUtils->get_OSDefs();  # Get defs for this host
                print "CHMOD = $osdefs{'CHMOD'}\n";

                # You can also use a global variable:
                my %osdefs =
                   ServerUtils->get_OSDefs();  # Get for current machine
                print "CHMOD = $::CHMOD\n";
        Comments:
                The pathnames must be defined in CSMDefs.pm.

=cut

#--------------------------------------------------------------------------------

sub get_OSDefs
{
    my $class         = shift;
    my $args_provided = (@_);

    my (
        $osname,            # eg Linux or AIX (case sensitive)
        $distro_name,       # eg RedHat or SuSE (case sensitive)
        $distro_version,    # eg 7.3 or 5.2
        $hw_arch,           # eg i386, ppc
        $csm_version,       # eg 1.3.0
        $no_globals,        # Don't set global variables if set to 1
    ) = @_;

    # Default to setting global variables
    $no_globals = 0 if (!$no_globals);

    # Set defaults if no arguments were provided
    # Note below that some of these require command pathnames to be defined.
    # Therefore, the pathnames must be defined in CSMDefs.pm.
    if (!$args_provided)
    {
        $osname         = $::PLTFRM;
        $distro_name    = NodeUtils->get_DistributionName;     #requires no cmds
        $distro_version = NodeUtils->get_DistributionVersion;  #requires LSLPP
        $hw_arch = InstallUtils->get_PkgArchitecture;  #requires UNAME for Linux
        $csm_version =
          InstallUtils->get_CSMVersion("csm.core");   #requires RPMCMD and LSLPP
    }
    my $munge = join(
                     "|::|",
                     (
                      $osname,  $distro_name, $distro_version,
                      $hw_arch, $csm_version
                     )
                     );
    if ($::all_OSDefs{$munge})
    {
        ($::DEBUG) && print "Found $munge in OSDefs hash\n";
        return (%{$::all_OSDefs{$munge}});
    }

    InstallUtils->get_osdefs_files($osname, $distro_name, $distro_version,
                                   $hw_arch, $csm_version);

    # Assign each hash element to a global variable unless $no_globals is set
    unless ($no_globals)
    {
        foreach my $key (keys %::OSDefs)
        {
            my $value = $::OSDefs{$key};

            # Display the key and the value
            #print "$key : $value\n";

            # Assign each hash element to a global variable.
            # For example, the following has the effect of setting
            #    $::GREP = $value
            # In order for this to work, we need to temporarily turn off
            # strict type checking, until the end of this block.
            no strict 'refs';
            ${"main::$key"} = $value;
        }
    }

    # Store the attributes that were used to obtain this OSdefs
    $::OSDefs{OSDefs_osname}         = $osname;
    $::OSDefs{OSDefs_distro_name}    = $distro_name;
    $::OSDefs{OSDefs_distro_version} = $distro_version;
    $::OSDefs{OSDefs_hw_arch}        = $hw_arch;
    $::OSDefs{OSDefs_csm_version}    = $csm_version;

    # Make a local copy of OSDefs
    my %OSDefs = %::OSDefs;

    # Add it to all_pkgdefs
    $::all_OSDefs{$munge} = \%OSDefs;

    return %OSDefs;

}

#--------------------------------------------------------------------------------

=head3    get_osdefs_files

        Determine which definition files need to be loaded and load them.

        Arguments:
                $class,
                $osname,
                $distro_name,
                $distro_version,
                $hw_arch,
                $csm_version
        Returns:
                Array of defintion file names
        Globals:
                none
        Error:
                undefined
        Example:
                 ServerUtils->get_osdefs_files($osname,
                                                $distro_name,
                                                $distro_version,
                                                $hw_arch,
                                                $csm_version);
        Comments:
                Search order on Linux
                        Linux-RedHat7.3-i386.pm, Linux-RedHat7.3.pm,
                        Linux-RedHat.pm, Linux.pm
                Search order on AIX:
                        AIX-5.2.pm, AIX.pm

                Search for the files in either <pwd>/defs or $OSDEFS

=cut

#--------------------------------------------------------------------------------

sub get_osdefs_files
{
    my ($class, $osname, $distro_name, $distro_version, $hw_arch, $csm_version,)
      = @_;

    my $isAIX = ($osname eq "AIX");

    # Set these global variables to load the correct values from osdefs.
    $::csm_version = $csm_version;

    my $distro   = "${distro_name}${distro_version}";
    my $osdistro = "${osname}-${distro}";

    my @defsfiles;
    push(@defsfiles, "${osdistro}-${hw_arch}.pm") if (${hw_arch});
    push(@defsfiles, "${osdistro}.0-${hw_arch}.pm") if (${hw_arch} and $isAIX);
    push(@defsfiles, "${osdistro}.pm");
    push(@defsfiles, "${osdistro}.0.pm") if ($isAIX);
    push(@defsfiles, "${osname}-${distro_name}.pm") if (${distro_name});
    push(@defsfiles, "${osname}.pm");

    my $progdir = dirname($0);

    foreach my $file (@defsfiles)
    {
        foreach my $dir ("$progdir/defs", $::OSDEFS)
        {
            my $defsfile = "$dir/$file";
            ($::DEBUG)
              && NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                              'csminstall', 'V', 'IMsgChecking_For', $defsfile);
            if (-f $defsfile)
            {

                # Using "do" rather than "require" because require only loads
                # a file once.  We might need to load it again with a different
                # value for csm_version.
                #require "$defsfile";
                do "$defsfile";
                return $defsfile;
            }
        }
    }

    # If we get here, then there was nothing loaded.
    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                              'E1', 'EMsgNoDefsFiles', $::OSDEFS);

    #die "Error:  No OS Definition files to load in $::OSDEFS\n";
}

#--------------------------------------------------------------------------------

=head3    get_pkgdefs

        Read the set of pkgdefs variables into a hash.

        Calls get_pkgdefs_files to read the files in
        /opt/csm/install/pkgdefs.  The correct file(s) are
        chosen based on the parameters passed in to get_pkgdefs.

        If no parameters are provided, default values based on the
        current machine's configuration are filled in.

        Arguments: - optional
                $osname,                # eg Linux or AIX (case sensitive)
                $distro_name,           # eg RedHat or SuSE (case sensitive)
                $distro_version,        # eg 7.3 or 5.2
                $hw_arch,               # eg i386, ppc
                $mgmt_type,             # Either MgmtServer or MgdNode
                $csm_version,   
        Returns:
                Hash of pkgdef values by pkgdef variable name
        Globals:
                $::all_pkgdefs
                $::pkgdefs
                $::mgmt_type
                $::csm_version
        Error:
                undefined
        Example:
                my %pkgdefs =
                        ServerUtils->get_pkgdefs();            # Get for current machine

                print "DISTRO_NAME = $pkgdefs{'DISTRO_NAME'}\n";        # string example

                print "opensrc_prereqs = " .                            # array example
                join(" ", @{$pkgdefs{'opensrc_prereqs'}}) ."\n";

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_pkgdefs
{
    my $class         = shift;
    my $args_provided = (@_);

    my (
        $osname,            # eg Linux or AIX (case sensitive)
        $distro_name,       # eg RedHat or SuSE (case sensitive)
        $distro_version,    # eg 7.3 or 5.2
        $hw_arch,           # eg i386, ppc
        $mgmt_type,         # Either MgmtServer or MgdNode
        $csm_version,       # eg 1.3.0
    ) = @_;

    # Set defaults if no arguments were provided
    # Note below that some of these require command pathnames to be defined.
    # Therefore, the pathnames must be defined in CSMDefs.pm.
    if (!$args_provided)
    {
        $osname         = $::PLTFRM;
        $distro_name    = NodeUtils->get_DistributionName;     #requires no cmds
        $distro_version = NodeUtils->get_DistributionVersion;  #requires LSLPP
        $hw_arch = InstallUtils->get_PkgArchitecture;  #requires UNAME for Linux
        $mgmt_type   = "MgmtServer";
        $csm_version =
          InstallUtils->get_CSMVersion("csm.core");   #requires RPMCMD and LSLPP
    }

    my $munge = join(
                     "|::|",
                     (
                      $osname,  $distro_name, $distro_version,
                      $hw_arch, $mgmt_type,   $csm_version
                     )
                     );
    if ($::all_pkgdefs{$munge})
    {
        ($::DEBUG) && print "Found $munge in pkgdefs hash\n";
        return (%{$::all_pkgdefs{$munge}});
    }

    # Set these global variables to load the correct values from pkgdefs.
    $::mgmt_type   = $mgmt_type;
    $::csm_version = $csm_version;

    InstallUtils->get_pkgdefs_files($osname, $distro_name, $distro_version,
                                    $hw_arch, $mgmt_type, $csm_version);

    # Store the attributes that were used to obtain this pkgdefs
    $::pkgdefs{pkgdefs_osname}         = $osname;
    $::pkgdefs{pkgdefs_distro_name}    = $distro_name;
    $::pkgdefs{pkgdefs_distro_version} = $distro_version;
    $::pkgdefs{pkgdefs_hw_arch}        = $hw_arch;
    $::pkgdefs{pkgdefs_mgmt_type}      = $mgmt_type;
    $::pkgdefs{pkgdefs_csm_version}    = $csm_version;

    # Make a local copy of pkgdefs
    my %pkgdefs = %::pkgdefs;

    # Add it to all_pkgdefs
    $::all_pkgdefs{$munge} = \%pkgdefs;

    return %pkgdefs;
}

#--------------------------------------------------------------------------------

=head3    get_pkgdefs_files

        Determine which definition files need to be loaded and load them.

        Arguments:
                $osname,
                $distro_name,
                $distro_version,
                $hw_arch,
                $mgmt_type,
                $csm_version
        Returns:
                Array of defintion file names
        Globals:
                $::mgmt_type
                $::csm_version
        Error:
                csmInstallCat E1
        Example:
                 ServerUtils->get_pkgdefs_files($osname,
                                                $distro_name,
                                                $distro_version,
                                                $hw_arch,
                                                $csm_version);
        Comments:
                Search order on Linux
                        Linux-RedHat7.3-i386.pm, Linux-RedHat7.3.pm,
                        Linux-RedHat.pm, Linux.pm
                Search order on AIX:
                        AIX-5.2.pm, AIX.pm
                Search for the files in either <pwd>/pkgdefs or $PKGDEFS

=cut

#--------------------------------------------------------------------------------

sub get_pkgdefs_files
{
    my ($class, $osname, $distro_name, $distro_version, $hw_arch, $mgmt_type,
        $csm_version,)
      = @_;

    my $isAIX = ($osname eq "AIX");

    # Set these global variables to load the correct values from pkgdefs.
    $::mgmt_type   = $mgmt_type;
    $::csm_version = $csm_version;

    my $distro   = "${distro_name}${distro_version}";
    my $osdistro = "${osname}-${distro}";

    my @defsfiles;
    push(@defsfiles, "${osdistro}-${hw_arch}.pm") if (${hw_arch});
    push(@defsfiles, "${osdistro}.0-${hw_arch}.pm") if (${hw_arch} and $isAIX);
    push(@defsfiles, "${osdistro}.pm");
    push(@defsfiles, "${osdistro}.0.pm") if ($isAIX);
    push(@defsfiles, "${osname}-${distro_name}.pm") if (${distro_name});
    push(@defsfiles, "${osname}.pm");

    my $progdir = dirname($0);

    foreach my $file (@defsfiles)
    {
        foreach my $dir ("$progdir/pkgdefs", $::PKGDEFS)
        {
            my $defsfile = "$dir/$file";
            ($::DEBUG)
              && NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                              'csminstall', 'V', 'IMsgChecking_For', $defsfile);
            if (-f $defsfile)
            {

                # Using "do" rather than "require" because require only loads
                # a file once.  We might need to load it again with different
                # values for mgmt_type or csm_version.
                #require "$defsfile";
                do "$defsfile";
                return $defsfile;
            }
        }
    }

    # If we get here, then there was nothing loaded.
    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                              'E1', 'EMsgNoDefsFiles', $::PKGDEFS);
}

#--------------------------------------------------------------------------------

1;

